// Get items and amounts from Purchase Orders table
function getPurchaseOrders(startDate, endDate) {
  return fetch(`api/purchaseOrders?startDate=${startDate}&endDate=${endDate}`)
    .then(response => response.json())
    .then(data => data.map(order => ({ item: order.item, amount: order.amount })));
}

// Get items and amounts from Bills table
function getBills(startDate, endDate) {
  return fetch(`api/bills?startDate=${startDate}&endDate=${endDate}`)
    .then(response => response.json())
    .then(data => data.map(bill => ({ item: bill.item, amount: bill.amount })));
}

// Get items and amounts from Salaries table
function getSalaries(startDate, endDate) {
  return fetch(`api/salaries?startDate=${startDate}&endDate=${endDate}`)
    .then(response => response.json())
    .then(data => data.map(salary => ({ item: salary.employee, amount: salary.amount })));
}

// Get items and amounts from Job Costing table
function getJobCosting(startDate, endDate) {
  return fetch(`api/jobCosting?startDate=${startDate}&endDate=${endDate}`)
    .then(response => response.json())
    .then(data => data.map(cost => ({ item: cost.item, amount: cost.amount })));
}

// Get items and amounts from Cash Deposit table
function getCashDeposit(startDate, endDate) {
  return fetch(`api/cashDeposit?startDate=${startDate}&endDate=${endDate}`)
    .then(response => response.json())
    .then(data => data.map(deposit => ({ item: deposit.source, amount: deposit.amount })));
}

=================

<?php

// Function to get items and amounts from Purchase Orders table
function getPurchaseOrders($startDate, $endDate) {
  $orders = []; // Initialize empty array

  // Connect to database
  $conn = mysqli_connect($servername, $username, $password, $dbname);

  // Check connection
  if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
  }

  // Query the Purchase Orders table
  $sql = "SELECT item, amount FROM purchase_orders WHERE date BETWEEN '$startDate' AND '$endDate'";
  $result = mysqli_query($conn, $sql);

  // Loop through the result set and add items and amounts to the orders array
  while ($row = mysqli_fetch_assoc($result)) {
    $order = array(
      "item" => $row["item"],
      "amount" => $row["amount"]
    );
    array_push($orders, $order);
  }

  // Close the database connection
  mysqli_close($conn);

  return $orders;
}

// Function to get items and amounts from Bills table
function getBills($startDate, $endDate) {
  $bills = []; // Initialize empty array

  // Connect to database
  $conn = mysqli_connect($servername, $username, $password, $dbname);

  // Check connection
  if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
  }

  // Query the Bills table
  $sql = "SELECT item, amount FROM bills WHERE date BETWEEN '$startDate' AND '$endDate'";
  $result = mysqli_query($conn, $sql);

  // Loop through the result set and add items and amounts to the bills array
  while ($row = mysqli_fetch_assoc($result)) {
    $bill = array(
      "item" => $row["item"],
      "amount" => $row["amount"]
    );
    array_push($bills, $bill);
  }

  // Close the database connection
  mysqli_close($conn);

  return $bills;
}

// Function to get items and amounts from Salaries table
function getSalaries($startDate, $endDate) {
  $salaries = []; // Initialize empty array

  // Connect to database
  $conn = mysqli_connect($servername, $username, $password, $dbname);

  // Check connection
  if (!$conn) {
    die("Connection failed: " . mysqli_connect_error());
  }

  // Query the Salaries table
  $sql = "SELECT employee, amount FROM salaries WHERE date BETWEEN '$startDate' AND '$endDate'";
  $result = mysqli_query($conn, $sql);

  // Loop through the result set and add employees and amounts to the salaries array
  while ($row = mysqli_fetch_assoc($result)) {
    $salary = array(
      "item" => $row["employee"],
      "amount" => $row["amount"]
    );
    array_push($salaries, $salary);
  }

  // Close the database connection
  mysqli_close($conn);
/////////////////////////////////////////////

<?php

$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];


    // Fetch data from Purchase Orders table
    $purchasesOrdersQuery = $pdo->prepare("SELECT item, SUM(amount) as total FROM purchase_orders WHERE date BETWEEN :startDate AND :endDate GROUP BY item");
    $purchasesOrdersQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result1 = $purchasesOrdersQuery->fetchAll();

    // Fetch data from Bills table
    $billsQuery = $pdo->prepare("SELECT item, SUM(amount) as total FROM bills WHERE date BETWEEN :startDate AND :endDate GROUP BY item");
    $billsQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result2 = $billsQuery->fetchAll();

    // Fetch data from Salaries table
    $salariesQuery = $pdo->prepare("SELECT employee_name, amount FROM salaries WHERE date BETWEEN :startDate AND :endDate");
    $salariesQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result3 = $salariesQuery->fetchAll();

    // Fetch data from Job Costing table
    $jobCostingQuery = $pdo->prepare("SELECT job_name, SUM(amount) as total FROM job_costing WHERE date BETWEEN :startDate AND :endDate GROUP BY job_name");
    $jobCostingQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result4 = $jobCostingQuery->fetchAll();

    // Fetch data from Cash Deposit table
    $cashDepositQuery = $pdo->prepare("SELECT bank_name, SUM(amount) as total FROM cash_deposit WHERE date BETWEEN :startDate AND :endDate GROUP BY bank_name");
    $cashDepositQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result5 = $cashDepositQuery->fetchAll();

// Create HTML table to display the results
echo "<table>
    <tr>
        <th>Item</th>
        <th>Purchase Order Total</th>
        <th>Bills Total</th>
    </tr>";

foreach ($result1 as $row1) {
    echo "<tr>
        <td>" . $row1["item"] . "</td>
        <td>" . $row1["total"] . "</td>";

    // Check if there is a matching record in the Bills table
    $match_found = false;
    foreach ($result2 as $row2) {
        if ($row1["item"] == $row2["item"]) {
            echo "<td>" . $row2["total"] . "</td>";
            $match_found = true;
            break;
        }
    }

    // If no matching record found in Bills table, display empty cell
    if (!$match_found) {
        echo "<td></td>";
    }

    echo "</tr>";
}

echo "</table>";

echo "<br><br>";

echo "<table>
    <tr>
        <th>Employee Name</th>
        <th>Salary Amount</th>
    </tr>";

foreach ($result3 as $row3) {
    echo "<tr>
        <td>" . $row3["employee_name"] . "</td>
        <td>" . $row3["amount"] . "</td>
    </tr>";
}

echo "</table>";

echo "<br><br>";

echo "<table>
    <tr>
        <th>Job Name</th>
        <th>Job Costing Total</th>
    </tr>";

foreach ($result4 as $row4) {
    echo "<tr>
        <td>" . $row4["job_name"] . "</td>
        <td>" . $row4["total"] . "</td>
    </tr>";
}

echo "</table>";

echo "<br><br>";

echo "<table>
    <tr>
        <th>Bank Name</th>
        <th>Cash Deposit Total</th>
    </tr>";

foreach ($result5 as $row5) {
    echo "<tr>
        <td>" . $row5["bank_name"] . "</td>
        <td>" . $row5["total"] . "</td>
        </tr>";
        }
        
        echo "</table>";
